#ifndef RemoteServerH
#define RemoteServerH

#include "protocol/AggreGateNetworkDevice.h"
#include <string>

class RemoteServer: public AggreGateNetworkDevice
{
private:
	AgString username;
	AgString password;

    bool ssl;

    void init();

public:
    static int DEFAULT_PORT() { return 6460; }
    static int DEFAULT_OPC_AGENT_PORT() { return 6481; }

    AgString DEFAULT_USERNAME;
    AgString DEFAULT_PASSWORD;

    AgString getPassword();
    AgString getUsername();
    bool getSsl();

    void setUsername(AgString username);
    void setPassword(AgString password);
    void setSsl(bool ssl);

    AgString getInfo();

    int hashCode();
    bool equals(AgObject* obj);

    RemoteServer();
    RemoteServer(AgString address, int port, AgString username, AgString password, bool ssl);
};

#endif
