#include "protocol/RemoteServer.h"
#include "Cres.h"

RemoteServer::RemoteServer()
    : AggreGateNetworkDevice()
{
    init();
    setPort(DEFAULT_PORT());
}

RemoteServer::RemoteServer(AgString address, int port, AgString username, AgString password, bool ssl)
    : AggreGateNetworkDevice(address, port)
{
    init();
    this->username = username;
    this->password = password;
    this->ssl = ssl;
}

void RemoteServer::init()
{
    type = Cres::get()->getString("server");
    id = "server";
    DEFAULT_USERNAME = "admin";
    DEFAULT_PASSWORD = "admin";
}

AgString RemoteServer::getPassword()
{
    return password;
}

AgString RemoteServer::getUsername()
{
    return username;
}

bool RemoteServer::getSsl()
{
    return ssl;
}

void RemoteServer::setUsername(AgString username)
{
    this->username = username;
}

void RemoteServer::setPassword(AgString password)
{
    this->password = password;
}

void RemoteServer::setSsl(bool ssl)
{
    this->ssl = ssl;
}

AgString RemoteServer::getInfo()
{
    return AggreGateNetworkDevice::getInfo() + (!username.empty() ? ", " + username : "");
}

int RemoteServer::hashCode()
{
    assert(0);
    return 0;
}

bool RemoteServer::equals(AgObject *obj)
{   
    if(obj == 0) {
        return false;
    }

    RemoteServer* other = dynamic_cast<RemoteServer*>(obj);
    if (this == other) {
        return true;
    }

    if (!AggreGateNetworkDevice::equals(other))
    {
        return false;
    }

    if(password != other->password){
        return false;
    }

    if(username != other->username) {
        return false;
    }    

	return true;
}



