#ifndef AggreGateNetworkDeviceH
#define AggreGateNetworkDeviceH

#include "protocol/AggreGateDevice.h"

class AggreGateNetworkDevice: public AggreGateDevice
{

private:	
	AgString address;
	int port;
	int64_t connectionTimeout;

    void init();


public:
    static AgString DEFAULT_ADDRESS() { return "127.0.0.1"; }
    static int64_t DEFAULT_CONNECTION_TIMEOUT() { return 20 * TimeHelper::SECOND_IN_MS(); }

    AgString getAddress();
    int getPort();
    void setPort(int port);
	void setAddress(AgString address);
    int64_t getConnectionTimeout();
    void setConnectionTimeout(int64_t connectionTimeout);
	AgString getInfo();
    int hashCode();
    bool equals(AgObject* obj);

	AggreGateNetworkDevice();
	AggreGateNetworkDevice(AgString address, int port);

};

#endif
