#ifndef AggreGateDeviceH
#define AggreGateDeviceH

#include "util/TimeHelper.h"
#include <string>
#include "util/AgObject.h"

class AggreGateDevice : public AgObject
{
 protected:
    AgString id;
    AgString type;

 private:
    AgString name;
    AgString description;
    bool disabled;
    int64_t commandTimeout;

    void init();

public:

    static int64_t DEFAULT_COMMAND_TIMEOUT() { return TimeHelper::HOUR_IN_MS(); }

    AgString getName();
    void setName(const AgString &name);
    void setDescription(const AgString &description);
    AgString getType();
    AgString getId();
    AgString getDescription();
    bool isDisabled();
    void setDisabled(bool disabled);
    int64_t getCommandTimeout();
    void setCommandTimeout(int64_t commandTimeout);
    AgString getInfo();
    virtual AgString toString();
    virtual int hashCode();
    virtual bool equals(AgObject *obj);

    AggreGateDevice();
    AggreGateDevice(AgString name);

};

#endif
