#include "AggreGateDevice.h"
#include <string>
#include "util/simpleobject/AgString.h"

AggreGateDevice::AggreGateDevice()
{
    init();
}

AggreGateDevice::AggreGateDevice(AgString name)
{
    init();
    this->name = name;
}

void AggreGateDevice::init()
{
    id = "generic";
    type = "Generic AggreGate Device";
    commandTimeout = DEFAULT_COMMAND_TIMEOUT();
    disabled = false;
    name = id;
    description = type;
}


AgString AggreGateDevice::getName()
{
    return name;
}

void AggreGateDevice::setName(const AgString &name)
{
    this->name = name;
}

void AggreGateDevice::setDescription(const AgString &description)
{
    this->description = description;
}

AgString AggreGateDevice::getType()
{
    return type;
}

AgString AggreGateDevice::getId()
{
    return id;
}

AgString AggreGateDevice::getDescription()
{
    return description;
}

bool AggreGateDevice::isDisabled()
{
    return disabled;
}

void AggreGateDevice::setDisabled(bool disabled)
{
    this->disabled = disabled;
}

int64_t AggreGateDevice::getCommandTimeout()
{
    return commandTimeout;
}

void AggreGateDevice::setCommandTimeout(int64_t commandTimeout)
{
    this->commandTimeout = commandTimeout;
}

AgString AggreGateDevice::getInfo()
{
    return type;
}

AgString AggreGateDevice::toString()
{
    AgString res = (getDescription().length() > 0) ? getDescription() : getType();
    return res + " (" + getInfo() + ")";
}

int AggreGateDevice::hashCode()
{
    assert(0);
    const int prime = 31;
    int result = 1;
    result = prime * result + ((description.length() == 0) ? 0 : AgString(description).hashCode());
    result = prime * result + (disabled ? 1231 : 1237);
    result = prime * result + ((name.length() == 0) ? 0 : AgString(name).hashCode());
    return result;
}

bool AggreGateDevice::equals(AgObject *obj)
{
	if(this == obj)
    {
        return true;
    }
    if(obj == 0)
    {
        return false;
    }

    AggreGateDevice *other = dynamic_cast<AggreGateDevice *>(obj);
    if (!other)
    {
        return false;
    }

    if(description != other->description)
    {
        return false;
    }
    if (disabled != other->disabled)
    {
        return false;
    }
    if(name != other->name)
    {
        return false;
    }
    return true;
}





