#include "protocol/AggreGateCommandUtils.h"
#include "util/simpleobject/AgString.h"
#include "datatable/encoding/TransferEncodingHelper.h"

OutgoingAggreGateCommandPtr AggreGateCommandUtils::startMessage()
{
    OutgoingAggreGateCommandPtr cmd = OutgoingAggreGateCommandPtr(new OutgoingAggreGateCommand());
    cmd->addParam(AgString(AggreGateCommand::COMMAND_CODE_MESSAGE));
    cmd->addParam(cmd->generateId());
    cmd->addParam(AgString(AggreGateCommand::MESSAGE_CODE_START));
    cmd->addParam(AgString::fromInt(CLIENT_PROTOCOL_VERSION));
    return cmd;
}

OutgoingAggreGateCommandPtr AggreGateCommandUtils::operationMessage()
{
    OutgoingAggreGateCommandPtr cmd = OutgoingAggreGateCommandPtr(new OutgoingAggreGateCommand());
    cmd->addParam(AgString(AggreGateCommand::COMMAND_CODE_MESSAGE));
    cmd->addParam(cmd->generateId());
    cmd->addParam(AgString(AggreGateCommand::MESSAGE_CODE_OPERATION));
    return cmd;
}

OutgoingAggreGateCommandPtr AggreGateCommandUtils::getVariableOperation(const AgString & context, const AgString & name)
{
    OutgoingAggreGateCommandPtr cmd = operationMessage();
    cmd->addParam(AgString(AggreGateCommand::COMMAND_OPERATION_GET_VAR));
    cmd->addParam(context);
    cmd->addParam(name);
    return cmd;
}

OutgoingAggreGateCommandPtr AggreGateCommandUtils::setVariableOperation(
        const AgString & context,
        const AgString & name,
        const AgString & encodedValue)
{
    OutgoingAggreGateCommandPtr cmd = operationMessage();
    cmd->addParam(AgString(AggreGateCommand::COMMAND_OPERATION_SET_VAR));
    cmd->addParam(context);
    cmd->addParam(name);
    cmd->addParam(encodedValue);
    return cmd;
}

OutgoingAggreGateCommandPtr AggreGateCommandUtils::callFunctionOperation(
    const AgString & context,
    const AgString & name,
    const AgString & encodedParameters)
{
    OutgoingAggreGateCommandPtr cmd = operationMessage();
    cmd->addParam(AgString(AggreGateCommand::COMMAND_OPERATION_CALL_FUNCTION));
    cmd->addParam(context);
    cmd->addParam(name);
    cmd->addParam(encodedParameters);

    return cmd;
}

OutgoingAggreGateCommandPtr AggreGateCommandUtils::addEventListenerOperation(
    const AgString & context,
    const AgString & name,
    int  listenerHashCode,
    const AgString & filter)
{
    OutgoingAggreGateCommandPtr cmd = operationMessage();
    cmd->addParam(AgString(AggreGateCommand::COMMAND_OPERATION_ADD_EVENT_LISTENER));
    cmd->addParam(context);
    cmd->addParam(name);
    cmd->addParam(listenerHashCode != 0 ? AgString::fromInt(listenerHashCode) : "");
    cmd->addParam(TransferEncodingHelper::encode(filter));

    return cmd;
}

OutgoingAggreGateCommandPtr AggreGateCommandUtils::removeEventListenerOperation(
    const AgString & context,
    const AgString & name,
    int  listenerHashCode,
    const AgString & filter)
{
    OutgoingAggreGateCommandPtr cmd = operationMessage();
    cmd->addParam(AgString(AggreGateCommand::COMMAND_OPERATION_REMOVE_EVENT_LISTENER));
    cmd->addParam(context);
    cmd->addParam(name);
    cmd->addParam(listenerHashCode != 0 ? AgString::fromInt(listenerHashCode) : "");
    if (!filter.empty())
    {
        cmd->addParam(TransferEncodingHelper::encode(filter));
    }

    return cmd;
}
