#pragma once

#include "plugin/ExtensionsPlugin.h"
#include "util/net.h"
#include <string>
#include <map>

class PluginDirector
{
private:
    ExtensionsPluginPtr extensionsPlugin;
    std::list<AgString> allowedPlugins;
    std::map<AgString, AgString> pluginIdMap;
    void loadPlugins(const AgString & dirList);

public:
    static AgString PLUGIN_DIRS_SEPARATOR() { return ","; }
    static AgString PLUGIN_FILE_EXTENSION() { return ".jar"; }
    static AgString EXTENSIONS_PLUGIN_ID() { return "com.tibbo.aggregate.common.plugin.extensions"; }

    virtual ContextManager* getContextManager() = 0;
    virtual CallerControllerPtr getCallerController() = 0;
    virtual ContextPtr createGlobalConfigContext(BasePluginPtr plugin, ContextPtr rootContext, bool requestReboot, VariableDefinitionPtr/*...*/ properties) = 0;
    virtual ContextPtr createUserConfigContext(BasePluginPtr plugin, ContextPtr userContext, bool requestReboot, VariableDefinitionPtr/*...*/ properties) = 0;


    void stop();

    AgString convertId(const AgString & id);

	BasePluginPtr getExistingPlugin(const AgString & id);
	bool isPluginAllowed(const AgString & id);

    ExtensionsPluginPtr getExtensionsPlugin();

    PluginDirector(const AgString & homeDir, const AgString & additionalPluginDirs, std::list<AgString> allowedPlugins);
};
