#include "plugin/BasePlugin.h"
#include "plugin/PluginDirector.h"
#include "context/ContextUtils.h"

BasePlugin::BasePlugin() 
{

}

BasePlugin::BasePlugin(const AgString & description) 
{ 
    this->description = description;
}


void BasePlugin::init()
{
    index = BasePlugin::INDEX_NORMAL();
}


AgString BasePlugin::getId()
{
    return id;
}

void BasePlugin::setId(const AgString & id)
{
    this->id = id;
}

AgString BasePlugin::getShortId()
{
    //not used
    assert(0);
    return "";
}

AgString BasePlugin::getDescription()
{
    return description;
}

void BasePlugin::setDescription(const AgString & description)
{
    this->description = description;
}

PluginDirectorPtr BasePlugin::getPluginDirector()
{
    return pluginDirector;
}

void BasePlugin::setPluginDirector(PluginDirectorPtr pluginDirector)
{
    this->pluginDirector = pluginDirector;
}

int BasePlugin::getSortIndex()
{
    return index;
}

void BasePlugin::setIndex(int index)
{
    this->index = index;
}

int BasePlugin::compareTo(BasePlugin *other)
{
    if(index != other->getSortIndex()) {
        return other->getSortIndex() - index;
    } else if(description.length() != 0 && other->getDescription().length() != 0) {
        return (getDescription() == other->getDescription());
    } else {
        return (getId() == other->getId());
    }
}

void BasePlugin::doStart()
{
}

void BasePlugin::doStop()
{
}

void BasePlugin::globalInit(ContextPtr rootContext)
{
    UNUSED(rootContext);
}

void BasePlugin::globalDeinit(ContextPtr rootContext)
{
    UNUSED(rootContext);
}

void BasePlugin::userInit(ContextPtr userContext)
{
    UNUSED(userContext);
}

void BasePlugin::userDeinit(ContextPtr userContext)
{
    UNUSED(userContext);
}

void BasePlugin::globalStart()
{
}

void BasePlugin::globalStop()
{
}
