#pragma once

#include "plugin/BasePlugin.h"
#include "plugin/ContextPlugin.h"
#include "context/Context.h"

class AbstractContextPlugin : public BasePlugin, public ContextPlugin
{

 public:
    void initialize();
    void deinitialize();
    void install(ContextManager* cm);
    void deinstall(ContextManager* cm);
	void install(ServerContextPtr context);
    void deinstall(ServerContextPtr context) ;
    void launch();
    void shutdown();


    AbstractContextPlugin();
    AbstractContextPlugin(const AgString & name);


    ContextPtr createGlobalConfigContext(ContextPtr rootContext, bool requestReboot, VariableDefinitionPtr properties);
    ContextPtr createUserConfigContext(ContextPtr userContext, bool requestReboot, VariableDefinitionPtr properties);
	AgString getDescription();
    ContextPtr getGlobalConfigContext();
	AgString getId();
    AgString getShortId();
    int getSortIndex();
    ContextPtr getUserConfigContext(const AgString & username);
    void globalDeinit(ContextPtr rootContext);
    void globalInit(ContextPtr rootContext);
    void globalStart();
    void globalStop();
    void userDeinit(ContextPtr userContext);
	void userInit(ContextPtr userContext);

};
