#pragma once

#include <string>

namespace Functions
{
    // Mathematical Functions
    static const AgString ABS = "abs";
    static const AgString ACOS = "acos";
    static const AgString ASIN = "asin";
    static const AgString ATAN = "atan";
    static const AgString CBRT = "cbrt";
    static const AgString CEIL = "ceil";
    static const AgString COS = "cos";
    static const AgString COSH = "cosh";
    static const AgString E = "e";
    static const AgString EXP = "exp";
    static const AgString EQ = "eq";
    static const AgString FLOOR = "floor";
    static const AgString GE = "ge";
    static const AgString GT = "gt";
    static const AgString LE = "le";
    static const AgString LOG = "log";
    static const AgString LOG10 = "log10";
    static const AgString LT = "lt";
    static const AgString MIN = "min";
    static const AgString MAX = "max";
    static const AgString NE = "ne";
    static const AgString PI = "pi";
    static const AgString POW = "pow";
    static const AgString RANDOM = "random";
    static const AgString ROUND = "round";
    static const AgString SIGNUM = "signum";
    static const AgString SIN = "sin";
    static const AgString SINH = "sinh";
    static const AgString SQRT = "sqrt";
    static const AgString TAN = "tan";
    static const AgString TANH = "tanh";
    static const AgString FORMAT_NUMBER = "formatNumber";

    // String Functions
    static const AgString CONTAINS = "contains";
    static const AgString ENDS_WITH = "endsWith";
    static const AgString FORMAT = "format";
    static const AgString GROUPS = "groups";
    static const AgString INDEX = "index";
    static const AgString IS_DIGIT = "isDigit";
    static const AgString IS_LETTER = "isLetter";
    static const AgString IS_LOWER_CASE = "isLowerCase";
    static const AgString IS_UPPER_CASE = "isUpperCase";
    static const AgString IS_WHITESPACE = "isWhitespace";
    static const AgString LAST_INDEX = "lastIndex";
    static const AgString LENGTH = "length";
    static const AgString LOWER = "lower";
    static const AgString REPLACE = "replace";
    static const AgString SPLIT = "split";
    static const AgString STARTS_WITH = "startsWith";
    static const AgString SUBSTRING = "substring";
    static const AgString TRIM = "trim";
    static const AgString UPPER = "upper";
    static const AgString URL_DECODE = "urlDecode";
    static const AgString URL_ENCODE = "urlEncode";

    // Date/Time Functions
    static const AgString DATE = "date";
    static const AgString DATE_ADD = "dateAdd";
    static const AgString DATE_DIFF = "dateDiff";
    static const AgString DAY = "day";
    static const AgString DAY_OF_WEEK = "dayOfWeek";
    static const AgString DAY_OF_YEAR = "dayOfYear";
    static const AgString FORMAT_DATE = "formatDate";
    static const AgString HOUR = "hour";
    static const AgString MILLISECOND = "millisecond";
    static const AgString MINUTE = "minute";
    static const AgString MONTH = "month";
    static const AgString NOW = "now";
    static const AgString SECOND = "second";
    static const AgString PRINT_PERIOD = "printPeriod";
    static const AgString TIME = "time";
    static const AgString YEAR = "year";

    // Color Processing Functions
    static const AgString BLUE = "blue";
    static const AgString BRIGHTER = "brighter";
    static const AgString COLOR = "color";
    static const AgString DARKER = "darker";
    static const AgString GREEN = "green";
    static const AgString RED = "red";

    // Data Table Processing Functions
    static const AgString ADD_COLUMNS = "addColumns";
    static const AgString ADD_RECORDS = "addRecords";
    static const AgString ADJUST_RECORD_LIMITS = "adjustRecordLimits";
    static const AgString AGGREGATE = "aggregate";
    static const AgString CELL = "cell";
    static const AgString CLEAR = "clear";
    static const AgString CONVERT = "convert";
    static const AgString COPY = "copy";
    static const AgString DESCRIBE = "describe";
    static const AgString DESCRIPTION = "description";
    static const AgString ENCODE = "encode";
    static const AgString FILTER = "filter";
    static const AgString GET_FORMAT = "getFormat";
    static const AgString HAS_FIELD = "hasField";
    static const AgString JOIN = "join";
    static const AgString PRINT = "print";
    static const AgString RECORDS = "records";
    static const AgString REMOVE_COLUMNS = "removeColumns";
    static const AgString REMOVE_RECORDS = "removeRecords";
    static const AgString SELECT = "select";
    static const AgString SET = "set";
    static const AgString SORT = "sort";
    static const AgString SUBTABLE = "subtable";
    static const AgString TABLE = "table";
    static const AgString UNION = "union";

    // Type Conversion Functions
    static const AgString BOOLEAN = "boolean";
    static const AgString INTEGER = "integer";
    static const AgString FLOAT = "float";
    static const AgString LONG = "long";
    static const AgString STRING = "string";
    static const AgString TIMESTAMP = "timestamp";

    // Context-Related Functions
    static const AgString AVAILABLE = "available";
    static const AgString CALL_FUNCTION = "callFunction";
    static const AgString DC = "dc";
    static const AgString DR = "dr";
    static const AgString DT = "dt";
    static const AgString EVENT_AVAILABLE = "eventAvailable";
    static const AgString EVENT_FORMAT = "eventFormat";
    static const AgString FIRE_EVENT = "fireEvent";
    static const AgString FUNCTION_AVAILABLE = "functionAvailable";
    static const AgString FUNCTION_INPUT_FORMAT = "functionInputFormat";
    static const AgString FUNCTION_OUTPUT_FORMAT = "functionOutputFormat";
    static const AgString GET_VARIABLE = "getVariable";
    static const AgString SET_VARIABLE = "setVariable";
    static const AgString VARIABLE_AVAILABLE = "variableAvailable";
    static const AgString VARIABLE_FORMAT = "variableFormat";
    static const AgString VARIABLE_READABLE = "variableReadable";
    static const AgString VARIABLE_WRITABLE = "variableWritable";

    // Miscellaneous Functions
    static const AgString EVALUATE = "evaluate";
    static const AgString LD = "ld";
    static const AgString SLEEP = "sleep";
    static const AgString ST = "st";
    static const AgString TRACE = "trace";
    static const AgString USER = "user";
    static const AgString XPATH = "xpath";

    // System Functions
    static const AgString ABSOLUTE = "absolute";
    static const AgString EXPRESSION_EDITOR_OPTIONS = "expressionEditorOptions";
    static const AgString HAS_RESOLVER = "hasResolver";

    // Function groups
    static const AgString GROUP_CONTEXT_RELATED = Cres::get()->getString("fContextOperations");
    static const AgString GROUP_DATA_TABLE_PROCESSING = Cres::get()->getString("fDataTableProcessing");
    static const AgString GROUP_NUMBER_PROCESSING = Cres::get()->getString("fNumberProcessing");
    static const AgString GROUP_TYPE_CONVERSION = Cres::get()->getString("fTypeConversion");
    static const AgString GROUP_DATE_TIME_PROCESSING = Cres::get()->getString("fDateTimeProcessing");
    static const AgString GROUP_COLOR_PROCESSING = Cres::get()->getString("fColorProcessing");
    static const AgString GROUP_SYSTEM = Cres::get()->getString("fSystem");
    static const AgString GROUP_STRING_PROCESSING = Cres::get()->getString("fStringProcessing");
    static const AgString GROUP_OTHER = Cres::get()->getString("fOther");

    // Deprecated Functions
    static const AgString HAS_VARIABLE = "hasVariable";
    static const AgString HAS_FUNCTION = "hasFunction";
    static const AgString HAS_EVENT = "hasEvent";
};
