// Generated from /aggregate_sdk_5.11.00/src/com/tibbo/aggregate/common/event/PersistenceBinding.java
#include "event/PersistenceBinding.h"
#include "IllegalStateException.h"
#include "Cres.h"


TableFormatPtr PersistenceBinding::FORMAT_;

TableFormatPtr PersistenceBinding::FORMAT()
{
    FORMAT_ = TableFormatPtr(new TableFormat());
    {
        FieldFormat* name = FieldFormat::create("<name><S><F=N><D=" + Cres::get()->getString("name") + ">");
        FORMAT_->addField(name);

        FieldFormat* type = FieldFormat::create("<type><S><F=N><D=" + Cres::get()->getString("type") + ">");
        type->addSelectionValue(AgObjectPtr(new AgString(TYPE_BOOLEAN_())), Cres::get()->getString("dtBoolean"));
        type->addSelectionValue(AgObjectPtr(new AgString(TYPE_STRING_())), Cres::get()->getString("dtString"));
        type->addSelectionValue(AgObjectPtr(new AgString(TYPE_INT_())), Cres::get()->getString("dtInteger"));
        type->addSelectionValue(AgObjectPtr(new AgString(TYPE_LONG_())), Cres::get()->getString("dtLong"));
        type->addSelectionValue(AgObjectPtr(new AgString(TYPE_FLOAT_())), Cres::get()->getString("dtFloat"));
        type->addSelectionValue(AgObjectPtr(new AgString(TYPE_DOUBLE_())), Cres::get()->getString("dtDouble"));
        type->addSelectionValue(AgObjectPtr(new AgString(TYPE_TIMESTAMP_())), Cres::get()->getString("date"));
        FORMAT_->addField(type);

        FieldFormat* index = FieldFormat::create("<index><S><F=N><D=" + Cres::get()->getString("index") + ">");
        FORMAT_->addField(index);

        FieldFormat* expression = FieldFormat::create("<expression><S><F=N><D=" + Cres::get()->getString("expression") + ">");
        FORMAT_->addField(expression);
    }
    return FORMAT_;
}

PersistenceBinding::PersistenceBinding() 
    : AggreGateBean(FORMAT())
{
}

PersistenceBinding::PersistenceBinding(DataRecordPtr record) 
    : AggreGateBean(FORMAT(), record)
{

}

PersistenceBinding::PersistenceBinding(const AgString & name, const AgString & type, const AgString & index, const AgString & expression) 
    : AggreGateBean(FORMAT())
{
    if (!index.empty() && index.length() > 2) {
        throw IllegalStateException("Index name length is limited to 2 characters to meed database name length limitations");
    }

    setName(name);
    setType(type);
    setIndex(index);
    setExpression(expression);
}

AgString PersistenceBinding::getType()
{
    return type;
}

AgString PersistenceBinding::getIndex()
{
    return index;
}

AgString PersistenceBinding::getName()
{
    return name;
}

AgString PersistenceBinding::getExpression()
{
    return expression;
}

ExpressionPtr PersistenceBinding::getCompiledExpression()
{
    if(compiledExpression == 0) {
        compiledExpression = !expression.empty() ? ExpressionPtr(new Expression(expression)) : ExpressionPtr();
    }
    return compiledExpression;
}

void PersistenceBinding::setName(const AgString & name)
{
    this->name = name;
}

void PersistenceBinding::setType(const AgString & type)
{
    this->type = type;
}

void PersistenceBinding::setIndex(const AgString & index)
{
    this->index = index;
}

void PersistenceBinding::setExpression(const AgString & expression)
{
    this->expression = expression;
}

PersistenceBinding* PersistenceBinding::clone()
{
    PersistenceBinding* clone = new PersistenceBinding;
    clone->name = name;
    clone->type = type;
    clone->index = index;
    clone->expression = expression;
    clone->compiledExpression = ExpressionPtr(compiledExpression->clone());

    return clone;
}

int PersistenceBinding::hashCode()
{
    assert(0);
    return 0;
}

bool PersistenceBinding::equals(AgObject *obj)
{
    if(this == obj)
        return true;

    if(obj == 0)
        return false;

    PersistenceBinding* other = static_cast< PersistenceBinding* >(obj);
    if(expression != other->expression)
        return false;

    if(index != other->index)
        return false;

    if(name!=other->name)
        return false;

     if(type!=other->type)
        return false;

    return true;
}

AgString PersistenceBinding::toString()
{
    return "PersistenceBinding [name=" + name + ", type=" + type + ", index=" + index + ", expression=" + expression + "]";
}
