#include "event/EventUtils.h"

int64_t EventUtils::generateEventId()
{
    return boost::posix_time::microsec_clock::local_time().time_of_day().total_microseconds();
}

std::list<EventDefinitionPtr>  EventUtils::getEvents(Context* context, const AgString & eventsMask, CallerControllerPtr caller)
{
    std::list<EventDefinitionPtr>  events;

    if (ContextUtils::ENTITY_GROUP_MASK() == eventsMask)
    {
        std::list<EventDefinitionPtr> list = context->getEventDefinitions(caller);
        for (std::list<EventDefinitionPtr>::iterator ed = list.begin(); ed != list.end(); ++ed)
        {
            if (!(*ed)->getGroup().empty() && ContextUtils::GROUP_SYSTEM() != (*ed)->getGroup())
            {
                events.push_back(*ed);
            }
        }
    }
    else
    {
        EventDefinitionPtr ed = context->getEventDefinition(eventsMask);
        if (ed.get() != NULL)
        {
            events.push_back(ed);
        }
    }

    return events;
}

bool EventUtils::matchesToMask(const AgString & eventMask, EventDefinitionPtr ed)
{
    
    if (ContextUtils::ENTITY_GROUP_MASK() == eventMask) {
        return (ContextUtils::GROUP_SYSTEM() != ed->getGroup());
    }
    return ed->getName() == eventMask;
}

bool EventUtils::matchesToMask(const AgString & eventMask, const AgString & event)
{
    UNUSED(eventMask);
    UNUSED(event);
    //Not used
    assert(0);
    return false;
}

DataTablePtr EventUtils::createSeverityStatisticsTable(int none, int notice, int info, int warning, int error, int fatal)
{
    UNUSED(none);
    UNUSED(notice);
    UNUSED(info);
    UNUSED(warning);
    UNUSED(error);
    UNUSED(fatal);
    //Not used
    assert(0);
    return DataTablePtr();
}

