#pragma once

#include <string>
#include <list>
#include <boost/shared_ptr.hpp>
#include "event/EventEnrichmentRule.h"
#include "datatable/TableFormat.h"
#include "data/Event.h"
#include "datatable/DataTableConversion.h"
#include "datatable/field/StringFieldFormat.h"
#include "datatable/field/LongFieldFormat.h"
#include "datatable/validator/TableKeyFieldsValidator.h"
#include "Cres.h"
#include "datatable/DataTableBindingProvider.h"
#include "datatable/converter/DefaultFormatConverter.h"

class EventProcessingRule : public AgObject
{
private:
    static AgString FIELD_MASK() { return "mask"; }
    static AgString FIELD_EVENT() { return "event"; }
    static AgString FIELD_PREFILTER() { return "prefilter"; }
    static AgString FIELD_DEDUPLICATOR() { return "deduplicator"; }
    static AgString FIELD_QUEUE() { return "queue"; }
    static AgString FIELD_DUPLICATE_DISPATCHING() { return "duplicateDispatching"; }
    static AgString FIELD_PERIOD() { return "period"; }
    static AgString FIELD_ENRICHMENTS() { return "enrichments"; }
    static TableFormatPtr FORMAT_;

    AgString mask;
    AgString event;
    AgString prefilter;
    AgString deduplicator;
    int queue;
    bool duplicateDispatching;
    int64_t period;
	std::list< EventEnrichmentRulePtr >  enrichments;
    ExpressionPtr prefilterExpression;
    ExpressionPtr deduplicatorExpression;
    int64_t filtered;
    int64_t saved;
    int64_t duplicates;

public:	
    AgString getEvent();
    AgString getMask();
    int64_t getPeriod();
    void setEvent(const AgString& event);
    void setMask(const AgString& mask);
    void setPeriod(int64_t period);
    AgString getPrefilter();
    void setPrefilter(const AgString& prefilter);
    ExpressionPtr getPrefilterExpression();
    AgString getDeduplicator();
    void setDeduplicator(const AgString& deduplicator);
    ExpressionPtr getDeduplicatorExpression();
    std::list< EventEnrichmentRulePtr >  &getEnrichments();
    void setEnrichments(std::list<EventEnrichmentRulePtr >  enrichments);
    int getQueue();
    void setQueue(int queue);
    bool isDuplicateDispatching();
    void setDuplicateDispatching(bool duplicateDispatching);
    void addFiltered();
    void addSaved();
    void addDuplicate();
    int64_t getFiltered();
    int64_t getSaved();
    int64_t getDuplicates();
    AgString toString();
    int hashCode();
    bool equals(AgObject *obj);
    std::string getClass();
    TableFormatPtr FORMAT();

	EventProcessingRule();
    EventProcessingRule(const AgString& mask, const AgString& event);

};
