#pragma once

#include "util/simpleobject/AgString.h"
#include <map>

class EventLevel
{
private:
    static std::map<int, AgString> LEVELS_;
    static std::map<int, AgString> SELECTION_VALUES_;

public:
    static int NUM_LEVELS() { return 5; }
    static int NONE() { return 0; }
    static int NOTICE() { return 1; }
    static int INFO() { return 2; }
    static int WARNING() { return 3; }
    static int ERROR_() { return 4; }
    static int FATAL() { return 5; }

    static bool isValid(int level);
    static const AgString getName(int level);
    static std::map<int, AgString> getSelectionValues();

private:
	static std::map<int, AgString> LEVELS();
    static std::map<int, AgString> SELECTION_VALUES();
};
