#pragma once

#include <iostream>
#include <string>
#include <boost/shared_ptr.hpp>
#include "util/simpleobject/AgDate.h"
#include "datatable/TableFormat.h"
#include "datatable/DataTableConversion.h"
#include "datatable/converter/DefaultFormatConverter.h"
#include "event/Acknowledgement.h"
#include "context/ContextUtils.h"


class Enrichment
{
 private:
    static AgString FIELD_NAME() { return "name"; }
    static AgString FIELD_VALUE() { return "value"; }
    static AgString FIELD_DATE() { return "date"; }
    static AgString FIELD_AUTHOR() { return "author"; }
    static TableFormatPtr FORMAT_;

    AgString name;
    AgString value;
    AgDatePtr date;
    AgString author;

    static TableFormatPtr initEnrichment();

 public:	
    AgString getName();
    void setName(const AgString& name);
    AgString getValue();
    void setValue(const AgString& value);
    AgDatePtr getDate();
    void setDate(AgDatePtr date);
    AgString getAuthor();
    void setAuthor(const AgString& author);

	void Init();
    Enrichment();
    Enrichment(const AgString& name, const AgString& value, AgDatePtr date, const AgString& author);

    static TableFormatPtr FORMAT();
};
