#include "event/Enrichment.h"

#include "AggreGateException.h"
#include "IllegalStateException.h"
#include "Cres.h"
#include "context/ContextUtils.h"

TableFormatPtr Enrichment::FORMAT_ = Enrichment::initEnrichment();


TableFormatPtr Enrichment::initEnrichment()
{
    TableFormatPtr tf = TableFormatPtr(new TableFormat());

    tf->addField("<"+FIELD_NAME() +"><S><D="+Cres::get()->getString("name")+">");
    tf->addField("<"+FIELD_VALUE() +"><S><D="+Cres::get()->getString("value")+">");
    tf->addField("<"+FIELD_DATE() +"><D><D="+Cres::get()->getString("date")+">");
    tf->addField("<"+FIELD_AUTHOR() +"><S><F=N><D="+Cres::get()->getString("author")+">");
    tf->setNamingExpression(+"print({}, \"{"+FIELD_NAME()+"} + '=' + {"+FIELD_VALUE() +"} + ' (' + {"+FIELD_DATE() +"} + ', ' + {"+FIELD_AUTHOR() +"} + ')'\", \"; \")");

    DataTableConversion::instance().registerFormatConverter(FormatConverterPtr(new DefaultFormatConverter(typeid(Enrichment).name(), FORMAT_)));
    return tf;
}

Enrichment::Enrichment()
{

}

Enrichment::Enrichment(const AgString& name, const AgString& value, AgDatePtr date, const AgString& author)
{ 
    if (!ContextUtils::isValidContextName(name)) {
        throw IllegalStateException("Illegal enrichment name: "+name);
    }
	
    this->name = name;
    this->value = value;
    this->date = date;
    this->author = author;
}

AgString Enrichment::getName()
{
    return name;
}

void Enrichment::setName(const AgString& name)
{
    this->name = name;
}

AgString Enrichment::getValue()
{
    return value;
}

void Enrichment::setValue(const AgString& value)
{
    this->value = value;
}

AgDatePtr Enrichment::getDate()
{
    return date;
}

void Enrichment::setDate(AgDatePtr date)
{
    this->date = date;
}

AgString Enrichment::getAuthor()
{
    return author;
}

void Enrichment::setAuthor(const AgString& author)
{
   this->author = author;
}

TableFormatPtr Enrichment::FORMAT()
{
    return FORMAT_;
}
