#pragma once

#include <string>
#include <boost/shared_ptr.hpp>

#include "util/Cloneable.h"
#include "util/simpleobject/AgDate.h"
#include "datatable/DataTableConversion.h"

#include "datatable/converter/DefaultFormatConverter.h"
#include "Cres.h"
#include "datatable/TableFormat.h"

class Acknowledgement : public Cloneable
{
private:
    static AgString FIELD_AUTHOR() { return "author"; }
    static AgString FIELD_TIME() { return "time"; }
    static AgString FIELD_TEXT() { return "text"; }
    static TableFormatPtr FORMAT_;
    AgString author;
    AgDate time;
    AgString text;

    void initFormat();

public:
    AgString getAuthor();
    AgString getText();
    AgDate getTime();
    void setAuthor(const AgString& author);
    void setText(const AgString& text);
    void setTime(AgDate time);
	TableFormatPtr getFormat();
    
    virtual Cloneable* clone();

    Acknowledgement();
    Acknowledgement(const AgString& author, AgDate time, const AgString& text);

    static TableFormatPtr FORMAT();
};
