#include "event/Acknowledgement.h"

TableFormatPtr Acknowledgement::FORMAT_;


Acknowledgement::Acknowledgement()
{
}

Acknowledgement::Acknowledgement(const AgString& author, AgDate time, const AgString& text)
{
  this->author = author;
  this->time = time;
  this->text = text;
}


AgString Acknowledgement::getAuthor()
{
    return author;
}

AgString Acknowledgement::getText()
{
    return text;
}

AgDate Acknowledgement::getTime()
{
    return time;
}

void Acknowledgement::setAuthor(const AgString& author)
{
    this->author = author;
}

void Acknowledgement::setText(const AgString& text)
{
    this->text = text;
}

void Acknowledgement::setTime(AgDate time)
{
    this->time = time;
}

TableFormatPtr Acknowledgement::getFormat()
{
    return FORMAT();
}

Cloneable *Acknowledgement::clone()
{
    Acknowledgement *ac = new Acknowledgement;
    ac->author = this->author;
    ac->time = this->time;
    ac->text = this->text;

    return ac;
}

TableFormatPtr Acknowledgement::FORMAT()
{
    if (!FORMAT_.get())
    {
        FORMAT_ = TableFormatPtr(new TableFormat());
        FORMAT_->addField("<"+FIELD_AUTHOR() +"><S><F=N><D="+Cres::get()->getString("author")+">");
        FORMAT_->addField("<"+FIELD_TIME() +"><D><D="+Cres::get()->getString("time")+">");
        FORMAT_->addField("<"+FIELD_TEXT() +"><S><D="+Cres::get()->getString("text")+">");

        FORMAT_->setNamingExpression("print({}, \"{"+FIELD_TIME() +"} + ': ' + {"+FIELD_TEXT() +"} + ' (' + {"+FIELD_AUTHOR() +"} + ')'\", \"; \")");

        DataTableConversion::instance().registerFormatConverter(FormatConverterPtr(new DefaultFormatConverter("Acknowledgement::class_()", FORMAT_)));
    }

    return FORMAT_;
}

