#include "device/sync/SynchronizationResult.h"
#include <stdexcept>

std::map<int, AgString> SynchronizationResult::CODES;

static const int CODE_OK = 0;
static const int CODE_SUSPENDED = 10;
static const int CODE_DISABLED_BY_DEPENDENCY = 20;
static const int CODE_DECLINED_BY_DRIVER = 30;
static const int CODE_CONNECTION_FAILED = 40;
static const int CODE_INTERRUPTED = 50;
static const int CODE_DISCONNECTED = 60;
static const int CODE_ERROR = 70;

SynchronizationResult::SynchronizationResult()
{
    init();
}  

SynchronizationResult::SynchronizationResult(int code)
{
    init();
    if (CODES.end() != CODES.find(code))  {
        throw std::invalid_argument("Unknown synchronization result code: " + AgString::fromInt(code).toUtf8());
    }

    this->code = code;
} 

SynchronizationResult::SynchronizationResult(int code, const AgString &details)
{
    UNUSED(code);
    init();
    this->details = details;
}


void SynchronizationResult::init()
{
    CODES[CODE_OK] = Cres::get()->getString("devSyncResOk");
    CODES[CODE_SUSPENDED] = Cres::get()->getString("devSyncResSuspended");
    CODES[CODE_DISABLED_BY_DEPENDENCY] = Cres::get()->getString("devSyncResDisabledByDependency");
    CODES[CODE_DECLINED_BY_DRIVER] = Cres::get()->getString("devSyncResDeclinedByDriver");
    CODES[CODE_CONNECTION_FAILED] = Cres::get()->getString("devSyncResConnectionFailed");
    CODES[CODE_INTERRUPTED] = Cres::get()->getString("devSyncResInterruted");
    CODES[CODE_DISCONNECTED] = Cres::get()->getString("devSyncResDisconnected");
    CODES[CODE_ERROR] = Cres::get()->getString("devSyncResError");
}

bool SynchronizationResult::isSuccessful()
{
    return code == CODE_OK;
}

int SynchronizationResult::getCode()
{
    return code;
}


AgString SynchronizationResult::toString()
{
	AgString str1 = ": " + details;
	AgString str2 = "";
	return CODES[code] + (details.empty() == false ? str1 : str2);
}





