#ifndef SynchronizationParametersH
#define SynchronizationParametersH
 #define BOOST_THREAD_USE_LIB
#include "util/Cloneable.h"
#include "device/DeviceContext.h"
#include <string>
#include <set>

class SynchronizationParameters : public Cloneable
{
private:
    bool connectOnly;
    bool shouldReadMetadata;
    bool shouldPersistStatus;
    bool shouldUseExtendedStatus;
    std::set<AgString> variables;
    int directionOverride;

public:
    bool isShouldReadMetadata();
    bool isShouldPersistStatus();
    bool isConnectOnly();
    bool isFull();
    void addVariable(const AgString& variable);
    void removeVariable(const AgString& variable);
    std::set<AgString> getVariables();
    bool isShouldUseExtendedStatus();
    int getDirectionOverride();
    AgString toString();
    int hashCode();
    bool equals(SynchronizationParameters* obj);
    SynchronizationParameters* clone();

    SynchronizationParameters();
    SynchronizationParameters(const AgString& setting);
    SynchronizationParameters(bool connectOnly);
    SynchronizationParameters(const AgString& setting, int directionOverride);
    SynchronizationParameters(bool connectOnly, bool shouldReadMetadata, bool shouldPersistStatus, bool shouldUseExtendedStatus);
};

#endif 
