﻿#include "device/sync/SynchronizationParameters.h"

SynchronizationParameters::SynchronizationParameters()
{  
	this->connectOnly = false;
	this->shouldReadMetadata = true;
    this->shouldPersistStatus = true;
    this->shouldUseExtendedStatus = false;
}

SynchronizationParameters::SynchronizationParameters(const AgString& setting)
{
	this->connectOnly = false;
	this->shouldReadMetadata = false;
    this->shouldPersistStatus = false;
    this->shouldUseExtendedStatus = false;
	this->directionOverride = DeviceContext::DIRECTION_AUTO;
    variables.insert(setting);  
}

SynchronizationParameters::SynchronizationParameters(bool connectOnly)
{
    this->connectOnly = false;
	this->shouldReadMetadata = true;
    this->shouldPersistStatus = true;
    this->shouldUseExtendedStatus = false;
    this->connectOnly = connectOnly;
}

SynchronizationParameters::SynchronizationParameters(const AgString& setting, int directionOverride)
{
    this->connectOnly = false;
	this->shouldReadMetadata = false;
    this->shouldPersistStatus = false;
    this->shouldUseExtendedStatus = false;
	this->directionOverride = DeviceContext::DIRECTION_AUTO;
    variables.insert(setting);  
    this->directionOverride = directionOverride;
}

SynchronizationParameters::SynchronizationParameters(bool connectOnly, bool shouldReadMetadata, bool shouldPersistStatus, bool shouldUseExtendedStatus)
{
    this->connectOnly = false;
    this->shouldReadMetadata = true;
    this->shouldPersistStatus = true;
    this->shouldUseExtendedStatus = false;

    this->connectOnly = connectOnly;
    this->shouldReadMetadata = shouldReadMetadata;
    this->shouldPersistStatus = shouldPersistStatus;
    this->shouldUseExtendedStatus = shouldUseExtendedStatus;
}

bool SynchronizationParameters::isShouldReadMetadata()
{
    return shouldReadMetadata;
}

bool SynchronizationParameters::isShouldPersistStatus()
{
    return shouldPersistStatus;
}

bool SynchronizationParameters::isConnectOnly()
{
    return connectOnly;
}

bool SynchronizationParameters::isFull()
{
    return !variables.empty();
}

void SynchronizationParameters::addVariable(const AgString &variable)
{
    variables.insert(variable);
}

void SynchronizationParameters::removeVariable(const AgString &variable)
{
    variables.erase(variable);
}

std::set<AgString> SynchronizationParameters::getVariables()
{
    return variables;
}

bool SynchronizationParameters::isShouldUseExtendedStatus()
{
    return shouldUseExtendedStatus;
}

int SynchronizationParameters::getDirectionOverride()
{
    return directionOverride;
}

AgString SynchronizationParameters::toString()
{
    AgString str = (isShouldReadMetadata() ? "yes" : "no");
    return "read metadata: "+ str+", settings: ";//TODO: + StringUtils.print(variables);
}


int SynchronizationParameters::hashCode()
{
    const int prime = 31;
    int result = 1;
    result = prime * result + (connectOnly ? 1231 : 1237);
    result = prime * result + directionOverride;//todo - std::set<AgString>  hashCode()?
    result = prime * result + ((variables.empty() == true) ? 0 : 0xFF/*variables.hashCode()*/);
    result = prime * result + (shouldPersistStatus ? 1231 : 1237);
    result = prime * result + (shouldReadMetadata ? 1231 : 1237);
    result = prime * result + (shouldUseExtendedStatus ? 1231 : 1237);
    return result;
}


bool SynchronizationParameters::equals(SynchronizationParameters* obj)
{
    if (this == obj)
		return true;

    if (obj == NULL)
		return false;    
    SynchronizationParameters* other = dynamic_cast<SynchronizationParameters*>(obj);
    if (other == NULL)
        return false;

    if (connectOnly != other->connectOnly)
        return false;

    if (directionOverride != other->directionOverride)
        return false;

    if (variables != other->variables)
        return false;

    if (shouldPersistStatus != other->shouldPersistStatus)
        return false;

    if (shouldReadMetadata != other->shouldReadMetadata)
        return false;

    if (shouldUseExtendedStatus != other->shouldUseExtendedStatus)
        return false;

    return true;
}

//TODO:
SynchronizationParameters* SynchronizationParameters::clone()
{
    assert(0);
    return NULL;
}

