#include "device/sync/SynchronizationHandler.h"
#include "Cres.h"

SynchronizationHandler::SynchronizationHandler()
{
  synchronizationEnabled = true;   
}

void SynchronizationHandler::initialize(DeviceContextPtr deviceContext, const AgString & variable,
                                        SettingSynchronizationOptionsPtr synchronizationOptions, bool /*check*/)
{
    this->deviceContext = deviceContext;
    this->variable = variable;
    this->synchronizationOptions = synchronizationOptions;
}

void SynchronizationHandler::deinitialize()
{
}

void SynchronizationHandler::startSynchronization() 
{
}

bool SynchronizationHandler::isSynchronizationEnabled()
{
    return synchronizationEnabled;
}

void SynchronizationHandler::setSynchronizationEnabled(bool synchronizationEnabled)
{
    this->synchronizationEnabled = synchronizationEnabled;
}

DataTablePtr SynchronizationHandler::readFromCache(CallerControllerPtr caller, RequestControllerPtr request)
{
    UNUSED(caller);
    UNUSED(request);
    return DataTablePtr();
}

void SynchronizationHandler::writeToCache(CallerControllerPtr caller, RequestControllerPtr request, DataTablePtr value) 
{
    UNUSED(caller);
    UNUSED(request);
    UNUSED(value);
}

ValueWriter* SynchronizationHandler::createServerWriter()
{
    return 0;
}

ValueReader* SynchronizationHandler::createServerReader()
{
	return 0;
}

AgDatePtr SynchronizationHandler::getServerModificationTime()
{
  return deviceContext->getSettingStatus(variable)->getTime();
}

AgDatePtr SynchronizationHandler::getDeviceModificationTime()
{  
    return AgDatePtr();
}

bool SynchronizationHandler::isUpdatedOnTheServer(CallerControllerPtr caller) 
{
    UNUSED(caller);
    return deviceContext->getSettingStatus(variable)->isUpdated();
}

int SynchronizationHandler::getDirectionOverride()
{
    return DeviceContext::DIRECTION_AUTO;
}

VariableDefinitionPtr SynchronizationHandler::getPersistentDefinition(VariableDefinitionPtr vd)
{
    return VariableDefinitionPtr(vd->clone());
}

SettingSynchronizationOptionsPtr SynchronizationHandler::getSynchronizationOptions()
{
    return synchronizationOptions;
}

DeviceContextPtr SynchronizationHandler::getDeviceContext()
{
    return deviceContext;
}

AgString SynchronizationHandler::getVariable()
{
    return variable;
}

VariableStatusPtr SynchronizationHandler::getCustomStatus()
{
    return customStatus;
}

void SynchronizationHandler::setCustomStatus(VariableStatusPtr customStatus)
{
    this->customStatus = customStatus;
}




