#include "device/sync/SettingSynchronizationOptions.h"


SettingSynchronizationOptions::SettingSynchronizationOptions() 
{
 mode = DeviceContext::SYNC_MODE_NORMAL;
}

SettingSynchronizationOptions::SettingSynchronizationOptions(int64_t  syncPeriod)//:SettingSynchronizationOptions()  
{
  mode = DeviceContext::SYNC_MODE_NORMAL;
  this->syncPeriod = syncPeriod;
}

SettingSynchronizationOptions::SettingSynchronizationOptions(int64_t  updateHistoryStorageTime, int64_t  syncPeriod)//:SettingSynchronizationOptions(syncPeriod) 
{
  mode = DeviceContext::SYNC_MODE_NORMAL;
  this->syncPeriod = syncPeriod;
  this->updateHistoryStorageTime = updateHistoryStorageTime;
}

SettingSynchronizationOptions::SettingSynchronizationOptions(int64_t  updateHistoryStorageTime, int64_t  syncPeriod, int historyRate)//:SettingSynchronizationOptions(updateHistoryStorageTime, syncPeriod) 
{
  mode = DeviceContext::SYNC_MODE_NORMAL;
  this->syncPeriod = syncPeriod;
  this->updateHistoryStorageTime = updateHistoryStorageTime;
  this->historyRate = historyRate;
}



int SettingSynchronizationOptions::getMode()
{
    return mode;
}

void SettingSynchronizationOptions::setMode(int mode)
{
    this->mode = mode;
}

int64_t SettingSynchronizationOptions::getSyncPeriod()
{
    return syncPeriod;
}

void SettingSynchronizationOptions::setSyncPeriod(int64_t  syncPeriod)
{
    this->syncPeriod = syncPeriod;
}

AgString SettingSynchronizationOptions::getMaster()
{
    return master;
}

void SettingSynchronizationOptions::setMaster(const AgString & master)
{
    this->master = master;
}

 int64_t SettingSynchronizationOptions::getUpdateHistoryStorageTime()
{
    return updateHistoryStorageTime;
}

void SettingSynchronizationOptions::setUpdateHistoryStorageTime(int64_t  updateHistoryStorageTime)
{
    this->updateHistoryStorageTime = updateHistoryStorageTime;
}

int SettingSynchronizationOptions::getHistoryRate()
{
    return historyRate;
}

void SettingSynchronizationOptions::setHistoryRate(int historyRate)
{
    this->historyRate = historyRate;
}

AgString SettingSynchronizationOptions::getFilter()
{
    return filter;
}

ExpressionPtr SettingSynchronizationOptions::getFilterExpression()
{
    if((filterExpression == 0) && (filter.empty() == false) && (filter.length() > 0)) 
	{
        filterExpression = ExpressionPtr(new Expression(filter));
    }
    return filterExpression;
}

void SettingSynchronizationOptions::setFilter(const AgString & filter)
{
    this->filter = filter;
    filterExpression.reset();
}

AgString SettingSynchronizationOptions::getCondition()
{
    return condition;
}

ExpressionPtr SettingSynchronizationOptions::getConditionExpression()
{
    if((conditionExpression == 0) && (condition.empty() == false) && (condition.length() > 0)) 
	{
        conditionExpression = ExpressionPtr(new Expression(condition));
    }
    return conditionExpression;
}

void SettingSynchronizationOptions::setCondition(const AgString & condition)
{
    this->condition = condition;
    conditionExpression.reset();
}

SynchronizationHandlerPtr SettingSynchronizationOptions::getSynchronizationHandler()
{
    return synchronizationHandler;
}

void SettingSynchronizationOptions::setSynchronizationHandler(SynchronizationHandlerPtr synchronizationHandler)
{
    this->synchronizationHandler = synchronizationHandler;
}

int SettingSynchronizationOptions::getSynchronizationsCounter()
{
    return synchronizationsCounter;
}

void SettingSynchronizationOptions::incrementSynchronizationsCounter()
{
    synchronizationsCounter++;
}

SettingSynchronizationOptions* SettingSynchronizationOptions::clone()
{
    SettingSynchronizationOptions* sso = new SettingSynchronizationOptions();

    sso->mode = mode;
    sso->updateHistoryStorageTime = updateHistoryStorageTime;
    sso->syncPeriod = syncPeriod;
    sso->historyRate = historyRate;
    sso->filter = filter;
    sso->master = master;
    sso->condition = condition;    
    sso->synchronizationsCounter =synchronizationsCounter;

    return sso;
}




