#pragma once

#include "protocol/AbstractAggreGateDeviceController.h"

class AgentController : public AbstractAggreGateDeviceController
{
private:
    const static AgString RF_LOGIN() { return "login"; }
    const static AgString RF_REGISTER() { return "register"; }

    const static AgString RFOF_LOGIN_OWNER() { return "owner"; }
    const static AgString RFOF_LOGIN_NAME() { return "name"; }
    const static AgString RFOF_LOGIN_RESPONSE() { return "response"; }

    const static AgString RFOF_REGISTER_PASSWORD() { return "password"; }

    const static AgString F_CONFIRM_EVENT() { return "confirmEvent"; }    

    const static int CHALLENGE_LEN = 8;

    BlockingChannelPtr channel;

    AgString owner;
    AgString name;
    AgString response;
    AgString challenge;

    AgString password;

public:

    AgentController(AggreGateDevice *device, BlockingChannelPtr channel);
    virtual ~AgentController();

    virtual void send(CommandPtr cmd);
    virtual void start();
    virtual bool loginImpl();
    virtual void disconnectImpl();
    virtual void confirmEvent(Context* con, EventDefinitionPtr def, EventPtr event);
    virtual bool isConnected();

    static std::string calculatemd5(std::string msg);

    void getLoginDetails();
    void setPasswordForLogin(const AgString &password);

    AgString getUsername();
    AgString getOwnerName();

private:
    AgString createChallenge();    
};
