#ifndef ServerDeviceControllerH
#define ServerDeviceControllerH

#include "device/DeviceContext.h"
#include "util/Interface.h"
#include <string>
#include <boost/shared_ptr.hpp>

class ServerDeviceController : public Interface
{
 public:  
    static AgString TYPE_GENERIC() { return "generic"; }

    virtual AgString getType() = 0;
    virtual AgString getTypeName() = 0;
    virtual void install(DeviceContextPtr deviceContext) = 0;
    virtual void uninstall() = 0;
    virtual void start() = 0;
    virtual void stop() = 0;
    virtual AgString getDeviceIconId() = 0;
    virtual AgString getGroupName() = 0;
};

#endif
