#include "device/DeviceUtils.h"
#include "datatable/validator/ValidatorHelper.h"

DeviceUtils::DeviceUtils()
{
    NAME_FIELD = FieldFormat::create("<" + DeviceUtils::FIELD_DEVICE_NAME() + "><S><D=" + Cres::get()->getString("devDeviceName") + "><H=" + Cres::get()->getString("devDeviceNameHelp") + ">");

    NAME_FIELD->getValidators().push_back(FieldValidatorPtr(new IdValidator()));
    NAME_FIELD->getValidators().push_back(ValidatorHelper::getInstance().getNAME_LENGTH_VALIDATOR());
    NAME_FIELD->getValidators().push_back(ValidatorHelper::getInstance().getNAME_SYNTAX_VALIDATOR());

    DESCRIPTION_FIELD = FieldFormat::create("<" + DeviceUtils::FIELD_DEVICE_DESCRIPTION() + "><S><D=" + Cres::get()->getString("devDeviceDesc") + "><H=" + Cres::get()->getString("devDeviceDescHelp") + ">");
}


DeviceUtils::~DeviceUtils()
{  
    delete NAME_FIELD;
    delete DESCRIPTION_FIELD;
}

FieldFormat* DeviceUtils::getNAME_FIELD()
{
    return NAME_FIELD;
}

FieldFormat* DeviceUtils::getDESCRIPTION_FIELD()
{
    return DESCRIPTION_FIELD;
}
