#pragma once

#include "datatable/TableFormat.h"
#include "device/DeviceContext.h"
#include <cstdio>
#include <string>
#include <boost/shared_ptr.hpp>

class DeviceSettingStatus
{
	
private:

    AgDatePtr time;
    int64_t duration;
    bool updated;
    int direction;
    AgString error;
    static TableFormatPtr FORMAT_;

public:
    static AgString FIELD_NAME() { return "name"; }
    static AgString FIELD_TIME() { return "time"; }
    static AgString FIELD_DURATION() { return "duration"; }
    static AgString FIELD_UPDATED() { return "updated"; }
    static AgString FIELD_DIRECTION() { return "direction"; }
    static AgString FIELD_ERROR() { return "error"; }
	
    static TableFormatPtr FORMAT();


    AgDatePtr getTime();
    void setTime( AgDatePtr time);
    int64_t getDuration();
    void setDuration(int64_t duration);
    bool isUpdated();
    void setUpdated(bool updated);
    int getDirection();
    void setDirection(int direction);
    AgString getError();
    void setError(const AgString& error);

    DeviceSettingStatus();

};
