#ifndef _DeviceAssetDefinition_H_
#define _DeviceAssetDefinition_H_

#include "datatable/AggreGateBean.h"
#include "datatable/TableFormat.h"
#include "datatable/DataTableBindingProvider.h"
#include "util/Comparable.h"
#include <string>
#include <list>

class DeviceAssetDefinition: public AggreGateBean, public Comparable
{
private:
    static AgString FIELD_ID() { return "id"; }
    static AgString FIELD_DESCRIPTION() { return "description"; }
    static AgString FIELD_ENABLED() { return "enabled"; }
    static AgString FIELD_CHILDREN() { return "children"; }
    AgString id;
    AgString description;
    bool enabled;
	
    std::list<DeviceAssetDefinitionPtr>  children;
    static TableFormatPtr initFORMAT();

 public:
    AgString getId();
    void setId(const AgString& id);
    AgString getDescription();
    void setDescription(const AgString& description);
    bool isEnabled();
    void setEnabled(bool enabled);
    std::list<DeviceAssetDefinitionPtr> getChildren();
    void setChildren(std::list<DeviceAssetDefinitionPtr>  children);
    void addSubgroup(DeviceAssetDefinitionPtr child);
    int compareTo(Comparable *other);
    AgString toString();
    int hashCode();
    bool equals(DeviceAssetDefinitionPtr obj);
    void init();
    static TableFormatPtr FORMAT;

    DeviceAssetDefinition();
    DeviceAssetDefinition(DataRecordPtr data);
    DeviceAssetDefinition(const AgString& id, const AgString& description);

};

#endif
