#pragma once

#include "datatable/validator/AbstractFieldValidator.h"
#include "util/Pointers.h"
#include "util/simpleobject/AgString.h"

class NonNullValidator : public AbstractFieldValidator
{
private:
    AgString message;

public:
    NonNullValidator();
    NonNullValidator(const AgString& message);

    virtual bool shouldEncode();
    virtual AgString encode();
    virtual char getType();
    virtual AgObjectPtr validate(AgObjectPtr value);
    virtual int hashCode();
    virtual bool equals(AgObjectPtr obj);
    virtual NonNullValidator *clone();
};
