#include "datatable/validator/NonNullValidator.h"

#include "datatable/FieldFormat.h"
#include "datatable/ValidationException.h"
#include "Cres.h"
#include <boost/functional/hash.hpp>
#include "GlobalVars.h"

NonNullValidator::NonNullValidator()
{

}

NonNullValidator::NonNullValidator(const AgString& message)
{
    this->message = message;
}

bool NonNullValidator::shouldEncode()
{
    return true;
}

AgString NonNullValidator::encode()
{
    return "";
}

char NonNullValidator::getType()
{
    return AGG_GLOBAL.VALIDATOR_NON_NULL;
}

AgObjectPtr NonNullValidator::validate(AgObjectPtr value)
{
    if (value.get() == NULL)
    {
        throw ValidationException(message.length() ? message : Cres::get()->getString("dtValueIsRequired"));
    }

    return value;
}

int NonNullValidator::hashCode()
{
    static int prime = 31;
    int result = 1;
    result = prime * result + ((message.length() == 0) ? 0 : message.hashCode());
    return result;
}

bool NonNullValidator::equals(AgObjectPtr obj)
{
    if (this == obj.get())
    {
        return true;
    }

    if (!AbstractFieldValidator::equals(obj.get()))
    {
        return false;
    }

    NonNullValidator* other = dynamic_cast<NonNullValidator*>(obj.get());
    if (other)
    {
         if (other->message != message)
         {
            return false;
         }
    }
    else
    {
        throw ValidationException("dynamic_cast<NonNullValidator*> error in NonNullValidator::equals()");
    }

    return true;
}

NonNullValidator *NonNullValidator::clone()
{
    return new NonNullValidator(message);
}
