#pragma once

#include "datatable/validator/AbstractFieldValidator.h"
#include "util/Pointers.h"
#include "util/simpleobject/AgString.h"


class LimitsValidator : public AbstractFieldValidator
{
private:
    static const AgChar MIN_MAX_SEPARATOR = ' ';
    ComparablePtr min;
    ComparablePtr max;

public:
    LimitsValidator(FieldFormat &fieldFormat, const AgString& source);
    LimitsValidator(ComparablePtr min, ComparablePtr max);
    LimitsValidator(int min, int max);
    virtual bool shouldEncode();
    virtual char getType();

    ComparablePtr getMin();
    ComparablePtr getMax();
    virtual AgString encode();
    virtual AgObjectPtr validate(AgObjectPtr value);
    int hashCode();
    virtual bool equals(AgObject* obj);
    virtual LimitsValidator *clone();


private:
    void compare(Comparable &cv, const AgString& smallMessage, const AgString& bigMessage);

};
