#pragma once

#include "datatable/FieldFormat.h"

class LongFieldFormat : public FieldFormat
{
public:
    LongFieldFormat(const AgString &name);
    char getType();
    std::string getFieldClass();
    std::string getFieldWrappedClass();
    AgObjectPtr getNotNullDefault();
    AgObjectPtr valueFromString(const AgString &value, ClassicEncodingSettingsPtr settings, bool validate);
    AgString valueToString(AgObjectPtr value, ClassicEncodingSettingsPtr settings);

    static AgString encodePeriodEditorOptions(int minUnit, int maxUnit);

protected:
    std::list<AgString> getSuitableEditors();
    AgObjectPtr convertValue(AgObjectPtr value);

};
