#include "datatable/field/LongFieldFormat.h"
#include "util/simpleobject/AgLong.h"
#include "util/Util.h"
#include "util/simpleobject/AgString.h"
#include "GlobalVars.h"

LongFieldFormat::LongFieldFormat(const AgString &name) : FieldFormat(name)
{
}

char LongFieldFormat::getType()
{
    return AGG_GLOBAL.LONG_FIELD;
}

std::string LongFieldFormat::getFieldClass()
{
    return typeid(AgLong).name();
}

std::string LongFieldFormat::getFieldWrappedClass()
{
    return typeid(AgLong).name();
}

AgObjectPtr LongFieldFormat::getNotNullDefault()
{
    return AgObjectPtr(new AgLong(0));
}

AgObjectPtr LongFieldFormat::valueFromString(const AgString &value, ClassicEncodingSettingsPtr settings, bool validate)
{
    UNUSED(settings);
    UNUSED(validate);
    if (value.length() == 0)
    {
        return AgObjectPtr(new AgLong(0));
    }
    return AgObjectPtr(new AgLong((value.toInt64())));
}

AgString LongFieldFormat::valueToString(AgObjectPtr value, ClassicEncodingSettingsPtr settings)
{
    UNUSED(settings);
    return value.get() == NULL ? "" : value->toString();
}

AgString LongFieldFormat::encodePeriodEditorOptions(int minUnit, int maxUnit)
{
    return AgString::fromInt(minUnit) + " " + AgString::fromInt(maxUnit);
}

std::list<AgString> LongFieldFormat::getSuitableEditors()
{
    std::list<AgString> list;
    list.push_back(AGG_GLOBAL.EDITOR_LIST);
    list.push_back(AGG_GLOBAL.EDITOR_PERIOD);
    list.push_back(AGG_GLOBAL.EDITOR_BAR);
    list.push_back(AGG_GLOBAL.EDITOR_BYTES);
    return list;
}

AgObjectPtr LongFieldFormat::convertValue(AgObjectPtr value)
{
    if (value.get() == NULL)
        return value;

    AgLong *i = dynamic_cast<AgLong *>(value.get());
    if (i)
    {
        return AgObjectPtr(Util::convertToNumber(value, true, false));
    }

    return value;
}



