#include "datatable/field/IntFieldFormat.h"
#include "util/simpleobject/AgInteger.h"
#include "util/Util.h"
#include "GlobalVars.h"

IntFieldFormat::IntFieldFormat(const AgString &name) : FieldFormat(name)
{

}

char IntFieldFormat::getType()
{
    return AGG_GLOBAL.INTEGER_FIELD;
}

std::string IntFieldFormat::getFieldClass()
{
    return typeid(AgInteger).name();
}

std::string IntFieldFormat::getFieldWrappedClass()
{
    return typeid(AgInteger).name();
}

AgObjectPtr IntFieldFormat::getNotNullDefault()
{
    return AgObjectPtr(new AgInteger(0));
}

AgObjectPtr IntFieldFormat::valueFromString(const AgString &value, ClassicEncodingSettingsPtr settings, bool validate)
{
    UNUSED(settings);
    UNUSED(validate);
    if (value.length() == 0)
    {
        return AgObjectPtr(new AgInteger(0));
    }

    return AgObjectPtr(new AgInteger((value.toInt())));
}

AgString IntFieldFormat::valueToString(AgObjectPtr value, ClassicEncodingSettingsPtr settings)
{
    UNUSED(settings);
    return value.get() == NULL ? "" : value->toString();
}

std::list<AgString> IntFieldFormat::getSuitableEditors()
{
    std::list<AgString> list;
    list.push_back(AGG_GLOBAL.EDITOR_LIST);
    list.push_back(AGG_GLOBAL.EDITOR_BAR);
    list.push_back(AGG_GLOBAL.EDITOR_BYTES);
    list.push_back(AGG_GLOBAL.EDITOR_SPINNER);
    list.push_back(AGG_GLOBAL.EDITOR_EVENT_LEVEL);
    return list;
}

AgObjectPtr IntFieldFormat::convertValue(AgObjectPtr value)
{
    if (value.get() == NULL)
        return value;

    AgInteger *i = dynamic_cast<AgInteger *>(value.get());
    if (!i)
    {
        return AgObjectPtr(Util::convertToNumber(value, true, false));
    }

    return value;
}
