#pragma once

#include "datatable/FieldFormat.h"

class DoubleFieldFormat : public FieldFormat
{
public:
    DoubleFieldFormat(const AgString &name);
    char getType();
    std::string getFieldClass();
    std::string getFieldWrappedClass();
    AgObjectPtr getNotNullDefault();
    AgObjectPtr valueFromString(const AgString &value, ClassicEncodingSettingsPtr settings, bool validate);
    AgString valueToString(AgObjectPtr value, ClassicEncodingSettingsPtr settings);

protected:
    std::list<AgString> getSuitableEditors();
    AgObjectPtr convertValue(AgObjectPtr value);
};
