#pragma once

#include "datatable/FieldFormat.h"
#include "datatable/validator/AbstractFieldValidator.h"

class DataTableFieldFormat : public FieldFormat
{
public:
    DataTableFieldFormat(const AgString &name);
    char getType();
    std::string getFieldClass();
    std::string getFieldWrappedClass();
    AgObjectPtr getNotNullDefault();
    AgObjectPtr valueFromString(const AgString &value, ClassicEncodingSettingsPtr settings, bool validate);
    AgString valueToString(AgObjectPtr value, ClassicEncodingSettingsPtr settings);

    static AgString encodeEditorOptions(bool showTableData);
private:

    class LocalFieldValidator : public AbstractFieldValidator
    {
    public:
            LocalFieldValidator(DataTableFieldFormat* parentFF) : AbstractFieldValidator()
            {
                ff = parentFF;
            }

            virtual AgObjectPtr validate(AgObjectPtr value);

            virtual LocalFieldValidator *clone();

    private:
            DataTableFieldFormat *ff;
    };

    FieldValidatorPtr fieldValidator;
};
