#pragma once

#include "datatable/FieldFormat.h"
#include "util/Pointers.h"

class BooleanFieldFormat : public FieldFormat
{

public:
    BooleanFieldFormat(const AgString &name);
    char getType();
    std::string getFieldClass();
    std::string getFieldWrappedClass();
    AgObjectPtr getNotNullDefault();
    AgObjectPtr valueFromString(const AgString &value, ClassicEncodingSettingsPtr settings, bool validate);
    AgString valueToString(AgObjectPtr value, ClassicEncodingSettingsPtr settings);

protected:
    AgObjectPtr convertValue(AgObjectPtr value);
};
