#pragma once
#include <boost/thread/mutex.hpp>

class KnownFormatCollector
{
private:
    boost::mutex mutex;
    std::map<int, bool> formatIds;

public:
    bool isKnown(int formatId);
    bool isMarked(int formatId);
    void makeKnown(int formatId, bool mark);
    void markAll();
};
