#include "datatable/encoding/KnownFormatCollector.h"
#include <boost/thread/locks.hpp>

bool KnownFormatCollector::isKnown(int formatId)
{
    boost::lock_guard<boost::mutex> lock(mutex);
    return formatIds.find(formatId) != formatIds.end();
}

bool KnownFormatCollector::isMarked(int formatId)
{
    boost::lock_guard<boost::mutex> lock(mutex);
    if (formatIds.find(formatId) != formatIds.end())
    {
        bool marked = formatIds[formatId];
        return marked;
    }
    else
    {
        return false;
    }
}

void KnownFormatCollector::makeKnown(int formatId, bool mark)
{
    boost::lock_guard<boost::mutex> lock(mutex);
    formatIds[formatId] = mark;
}

void KnownFormatCollector::markAll()
{
    //not used
    assert(0);
}
