#pragma once
#include <map>
#include <boost/thread/mutex.hpp>
#include "util/Pointers.h"

class FormatCache
{
private:
    static const int RETRIES = 30;
    static const int TIMEOUT = 1000;

    std::map<int, TableFormatPtr> cache;
    boost::mutex cacheLock;
    AbstractAggreGateDeviceController* controller;

public:
    FormatCache(AbstractAggreGateDeviceController* controller);
    void put(int id, TableFormatPtr format);
    boost::shared_ptr<int> add(TableFormatPtr format);
    boost::shared_ptr<int> getId(TableFormatPtr format);
    TableFormatPtr getCachedVersion(TableFormatPtr format);
    TableFormatPtr get(int id);
    void clear();

private:
    void dump();

};
