#include "datatable/converter/AbstractFormatConverter.h"
#include "datatable/FieldFormat.h"
#include "datatable/DataTableUtils.h"
#include "Cres.h"

AbstractFormatConverter::AbstractFormatConverter(const AgString &valueClassType, TableFormatPtr format) :
    valueClass(valueClassType)
{
    this->format = format;
}

AbstractFormatConverter::AbstractFormatConverter(const AgString &valueClassType) :
    valueClass(valueClassType)
{
}

AgString AbstractFormatConverter::getValueClass()
{
    return valueClass;
}

void AbstractFormatConverter::setValueClass(const AgString &valueClassType)
{
    this->valueClass = valueClassType;
}

TableFormatPtr AbstractFormatConverter::getFormat()
{
    return format;
}

FieldFormat* AbstractFormatConverter::createFieldFormat(const AgString &name)
{
    return DataTableUtils::createTableField(name, format);
}
