#pragma once
#include "util/Pointers.h"
#include "util/simpleobject/AgString.h"

class QueryCondition
{
public:
    static const int EQ = 1;
    static const int GT = 2;
    static const int LT = 4;
    static const int NE = 8;
    static const int GE = GT | EQ;
    static const int LE = LT | EQ;

private:
    AgString field;
    AgObjectPtr value;
    int operator_;

public:
    QueryCondition(const AgString & field, AgObjectPtr value, int operator_ = EQ);
    AgString &getField();
    AgObjectPtr getValue();
    int getOperator();

};
