#pragma once
#include "util/Pointers.h"
#include <map>
#include <list>
#include <vector>
#include "util/simpleobject/AgString.h"

class DataTableUtils
{

public:
    static AgString NAMING_ENVIRONMENT_SHORT_DATA() { return "short"; }
    static AgString NAMING_ENVIRONMENT_FULL_DATA() { return "full"; }

    static const AgChar ELEMENT_START = 0x1c;
    static const AgChar ELEMENT_END = 0x1d;
    static const AgChar ELEMENT_NAME_VALUE_SEPARATOR = 0x1e;

    static const AgChar ELEMENT_VISIBLE_START = '<';
    static const AgChar ELEMENT_VISIBLE_END = '>';
    static const AgChar ELEMENT_VISIBLE_NAME_VALUE_SEPARATOR = '=';

    static const AgChar DATA_TABLE_NULL = 0x001a;
    static AgString DATA_TABLE_VISIBLE_NULL() { return "<NULL>"; }

private:
     static std::map<AgString, AgString> EDITOR_SELECTION_VALUES;
     static std::map<AgString, AgString> initMap();

public:
     static AgString transferDecode(AgString value);
     static AgString transferEncode(AgString value);
     static void inlineData(DataTablePtr table, ContextManager* cm, CallerControllerPtr cc);
     static std::map<AgString, AgString> &getEditorSelectionValues();
     static DataTablePtr wrapToTable(const std::vector<AgObjectPtr>& values);
     static DataTablePtr wrapToTable(std::map<AgString, AgObjectPtr>& values);
     static std::list<AgString> findDifferingFields(DataTablePtr first, DataTablePtr second);
     static DataTablePtr makeSubtable(DataTablePtr table,  std::list<AgString> fields);
     static EvaluatorPtr createEvaluator(DataTablePtr dataTable, ContextManager* contextManager, ContextPtr context);
     static AgString fieldValueToString(FieldFormat* ff, AgObjectPtr value);
     //static Charset detectCharset(byte[] data)
     static AgString createRecordKeyString(DataRecordPtr record, int rowNumber, AgString keyField);
     static DataTablePtr processBindings(DataTablePtr table, EvaluatorPtr evaluator);
     static DataTablePtr processBindings(DataTablePtr table, EvaluatorPtr evaluator, ErrorCollectorPtr errorCollector);
     static DataTablePtr processBindings(DataTablePtr table, EvaluatorPtr evaluator, ErrorCollectorPtr errorCollector, bool split);

     // from .NET sources
     static FieldFormat* createTableField(const AgString& name, TableFormatPtr format);

};

