#pragma once
#include "util/simpleobject/AgString.h"
#include <set>
#include <list>
#include "util/Pointers.h"

class DataTableReplication
{

public:
    static std::set<AgString> copy(DataTable &source, DataTablePtr target);
    static std::set<AgString> copy(DataTable &source, DataTablePtr target, bool copyReadOnlyFields);
    static std::set<AgString> copy(DataTable &source, DataTablePtr target, bool copyReadOnlyFields, bool copyNonReplicatableFields);
    static std::set<AgString> copy(DataTable &source, DataTablePtr target, bool copyReadOnlyFields, bool copyNonReplicatableFields, bool removeRecordsFromTarget);
    static std::set<AgString> copy(DataTable &source, DataTablePtr target, bool copyReadOnlyFields, bool copyNonReplicatableFields, bool removeRecordsFromTarget,
                                      bool addRecordsToTarget);
    static std::set<AgString> copy(DataTable &source, DataTablePtr target, bool copyReadOnlyFields, bool copyNonReplicatableFields, bool removeRecordsFromTarget,
                                      bool addRecordsToTarget, bool ignoreUnresizable);
    static std::set<AgString> copy(DataTable &source, DataTablePtr target, bool copyReadOnlyFields, bool copyNonReplicatableFields, bool removeRecordsFromTarget,
                                      bool addRecordsToTarget, bool ignoreUnresizable, std::list<AgString> fields);

    static std::set<AgString> copyWithKeyFields(DataTable& source, DataTablePtr target, bool copyReadOnlyFields, bool copyNonReplicatableFields, bool removeRecordsFromTarget,
                                       bool addRecordsToTarget, bool ignoreUnresizable, std::list<AgString> fields);

    static std::set<AgString> copyWithoutKeyFields(DataTable& source, DataTablePtr target, bool copyReadOnlyFields, bool copyNonReplicatableFields, bool removeRecordsFromTarget,
                                                      bool addRecordsToTarget, bool ignoreUnresizable, std::list<AgString> fields);
    static std::set<AgString> copyRecord(DataRecord& source, DataRecordPtr target);
    static std::set<AgString> copyRecord(DataRecord& source, DataRecordPtr target, bool copyReadOnlyFields, bool copyNonReplicatableFields);
    static std::set<AgString> copyRecord(DataRecord& source, DataRecordPtr target, bool copyReadOnlyFields, bool copyNonReplicatableFields, std::list<AgString> fields);
    static std::set<AgString> copyRecord(DataRecord& source, DataRecordPtr target, bool copyReadOnlyFields, bool copyNonReplicatableFields, bool removeRecordsFromTarget,
                                            bool addRecordsToTarget, std::list<AgString> fields);
};
