#pragma once

#include <string>
#include "util/Pointers.h"
#include "util/simpleobject/AgString.h"

class DataTableBuilding
{
public:
    static AgString FIELD_TABLE_FORMAT_MIN_RECORDS() { return "minRecords"; }
    static AgString FIELD_TABLE_FORMAT_MAX_RECORDS() { return "maxRecords"; }
    static AgString FIELD_TABLE_FORMAT_FIELDS() { return "fields"; }
    static AgString FIELD_TABLE_FORMAT_REORDERABLE() { return "reorderable"; }
    static AgString FIELD_TABLE_FORMAT_UNRESIZABLE() { return "unresizable"; }
    static AgString FIELD_TABLE_FORMAT_BINDINGS() { return "bindings"; }
    static AgString FIELD_FIELDS_FORMAT_OLDNAME() { return "oldname"; }
    static AgString FIELD_FIELDS_FORMAT_NAME() { return "name"; }
    static AgString FIELD_FIELDS_FORMAT_TYPE() { return "type"; }
    static AgString FIELD_FIELDS_FORMAT_DESCRIPTION() { return "description"; }
    static AgString FIELD_FIELDS_FORMAT_DEFAULT_VALUE() { return "defaultValue"; }
    static AgString FIELD_FIELDS_FORMAT_HIDDEN() { return "hidden"; }
    static AgString FIELD_FIELDS_FORMAT_INLINE() { return "inline"; }
    static AgString FIELD_FIELDS_FORMAT_READONLY() { return "readonly"; }
    static AgString FIELD_FIELDS_FORMAT_NULLABLE() { return "nullable"; }
    static AgString FIELD_FIELDS_FORMAT_KEY() { return "key"; }
    static AgString FIELD_FIELDS_FORMAT_SELVALS() { return "selvals"; }
    static AgString FIELD_FIELDS_FORMAT_EXTSELVALS() { return "extselvals"; }
    static AgString FIELD_FIELDS_FORMAT_HELP() { return "help"; }
    static AgString FIELD_FIELDS_FORMAT_EDITOR() { return "editor"; }
    static AgString FIELD_FIELDS_FORMAT_EDITOR_OPTIONS() { return "editorOptions"; }
    static AgString FIELD_SELECTION_VALUES_VALUE() { return "value"; }
    static AgString FIELD_SELECTION_VALUES_DESCRIPTION() { return "description"; }
    static AgString FIELD_BINDINGS_TARGET() { return "target"; }
    static AgString FIELD_BINDINGS_EXPRESSION() { return "expression"; }

private:
    TableFormatPtr SELECTION_VALUES_FORMAT;
    TableFormatPtr BINDINGS_FORMAT;
    TableFormatPtr FIELDS_FORMAT;
    TableFormatPtr TABLE_FORMAT;

    DataTableBuilding();
public:
    static DataTableBuilding& instance()
    {
        static DataTableBuilding dateDataTableBuilding;
        return dateDataTableBuilding;
    }

    DataTablePtr formatToFieldsTable(TableFormatPtr tf, bool readOnly);
    DataTablePtr formatToFieldsTable(TableFormatPtr tf, bool readOnly, ClassicEncodingSettingsPtr settings);
    DataTablePtr formatToFieldsTable(TableFormatPtr tf, bool readOnly, ClassicEncodingSettingsPtr settings, bool ignoreHiddenFields);
};
