#include "context/VariableInfo.h"
#include "datatable/TableFormat.h"
#include "datatable/DataRecord.h"
#include "datatable/DataTableBuilding.h"
#include "datatable/field/StringFieldFormat.h"
#include "context/VariableDefinition.h"
#include "Cres.h"
#include "GlobalVars.h"

TableFormatPtr VariableInfo::FORMAT = VariableInfo::initFORMAT();

TableFormatPtr VariableInfo::initFORMAT()
{
    TableFormatPtr tf = TableFormatPtr(new TableFormat(1, 1));

    tf->addField("<name><S><D=" + Cres::get()->getString("name") + ">");
    tf->addField("<description><S><D=" + Cres::get()->getString("description") + ">");
    tf->addField("<format><T><F=N><D=" + Cres::get()->getString("format") + ">");
    tf->addField("<readable><B><D=" + Cres::get()->getString("acReadable") + ">");
    tf->addField("<writable><B><D=" + Cres::get()->getString("acWritable") + ">");
    tf->addField("<help><S><F=N><D=" + Cres::get()->getString("help") + "><E=" + AGG_GLOBAL.EDITOR_TEXT_AREA + ">");
    tf->addField("<group><S><F=N><D=" + Cres::get()->getString("group") + ">");

    return tf;
}


DataTablePtr  VariableInfo::createInfoTable(VariableDefinitionPtr vd)
{
    DataRecordPtr res = DataRecordPtr(new DataRecord(FORMAT));
    res->addString(vd->getName());
    res->addString(vd->getDescription());
    res->addDataTable(vd->getFormat() != NULL ? DataTableBuilding::instance().formatToFieldsTable(vd->getFormat(), false) : DataTablePtr());
    res->addBoolean(vd->isReadable());
    res->addBoolean(vd->isWritable());
    res->addString(vd->getHelp());
    res->addString(vd->getGroup());

    return res->wrap();
}



