#ifndef VariableDataH
#define VariableDataH
#include "context/VariableDefinition.h"
#include <boost/thread/shared_mutex.hpp>

class VariableData : public Comparable
{
private:
    VariableDefinitionPtr definition;

    AgObjectPtr value;
	boost::shared_mutex readWriteLock;
    int64_t getCount;
    int64_t setCount;
    bool getterCached;
    bool setterCached;
    std::string getterMethod;
    std::string setterMethod;


public:
    void registerGetOperation();
    void registerSetOperation();
    VariableDefinitionPtr getDefinition();
    AgObjectPtr getValue();
    void setValue(AgObjectPtr value);

public:
    boost::shared_mutex& getReadWriteLock();
    int64_t getGetCount();
    int64_t getSetCount();
    bool isGetterCached();
    void setGetterCached(bool getterCached);
    bool isSetterCached();
    void setSetterCached(bool setterCached);
    int compareTo(Comparable *d);

    void setGetterMethod(const std::string& getter);
    std::string getGetterMethod();
    void setSetterMethod(const std::string& setter);
    std::string getSetterMethod();

    VariableData(VariableDefinitionPtr definition);

};

#endif
