#pragma once

#include "context/AbstractCallerController.h"
#include "util/Pointers.h"

class UncheckedCallerController : public AbstractCallerController
{

private:
    PermissionsPtr permissions;


public:
    PermissionsPtr getPermissions();
    bool isPermissionCheckingEnabled();
    bool isLoggedIn();
    void logout();
    bool isHeadless();
    void handleContextEvent(EventPtr event);


    UncheckedCallerController();
	UncheckedCallerController(const AgString & username);
};
