#ifndef FunctionDataH
#define FunctionDataH

#define BOOST_THREAD_USE_LIB

#include "util/Comparable.h"
#include "util/Pointers.h"
#include <boost/thread.hpp>

class FunctionData: public Comparable
{

private:
	FunctionDefinitionPtr definition;
    boost::recursive_mutex executionLock;
	int64_t executionCount;
	bool implementationCached;
    std::string implementationMethod;

public:
	void registerExecution();
	FunctionDefinitionPtr getDefinition();
    boost::recursive_mutex&  getExecutionLock();
	int64_t getExecutionCount();
	bool isImplementationCached();
	void setImplementationCached(bool implementationCached);
    std::string getImplementationMethod();
    void setImplementationMethod(const std::string& implementationMethod);

    virtual int compareTo(Comparable *d);

	FunctionData(FunctionDefinitionPtr definition);
};

#endif
