#ifndef EventDefinitionH
#define EventDefinitionH

#define BOOST_THREAD_USE_LIB

#include "AbstractEntityDefinition.h"
#include "util/Cloneable.h"

class EventDefinition : public AbstractEntityDefinition, public Cloneable
{

private:
	void init(const AgString &name, TableFormatPtr format, const AgString & description);

    TableFormatPtr format;
	bool hidden;
	PermissionsPtr permissions;
    int64_t expirationPeriod;
	int level;
	PermissionsPtr firePermissions;
	bool synchronous;
	PersistenceOptionsPtr persistenceOptions;
    unsigned int  memoryStorageSize;

public:
	void setFormat(TableFormatPtr format);
	void setHidden(bool hidden);
	void setPermissions(PermissionsPtr perms);
	void setExpirationPeriod(int64_t expirationPeriod);
	void setLevel(int level);
	void setSynchronous(bool synchronous);
	TableFormatPtr getFormat();
    bool isHidden();
    PermissionsPtr getPermissions();
    int64_t getExpirationPeriod();
    int getLevel();
    PermissionsPtr getFirePermissions();
    void setFirePermissions(PermissionsPtr firePermissions);
	bool isSynchronous();
	PersistenceOptionsPtr getPersistenceOptions();
    unsigned int getMemoryStorageSize();
    void setMemoryStorageSize(int  memoryStorageSize);
    Cloneable* clone();
    int compareTo(EventDefinition* d);
    int hashCode();
    bool equals(EventDefinition *obj);

public:
    EventDefinition(const AgString & name, TableFormatPtr format);
    EventDefinition(const AgString & name, TableFormatPtr format, const AgString & description);
    EventDefinition(const AgString & name, TableFormatPtr format, const AgString & description, const AgString & group);

};

#endif
